// DlgModArith.cpp : implementation file
//

#include "stdafx.h"
#include "ScienceCamp-2014.h"
#include "DlgModArith.h"
#include "afxdialogex.h"
#include <boost/xint/integer.hpp>



// CDlgModArith dialog

IMPLEMENT_DYNAMIC(CDlgModArith, CDialogEx)

CDlgModArith::CDlgModArith(CWnd* pParent /*=NULL*/)
	: CDialogEx(CDlgModArith::IDD, pParent)
{
	factored = false;
}

CDlgModArith::~CDlgModArith()
{
}

void IntegerFactorization(boost::xint::integer x, CArray<boost::xint::integer *, boost::xint::integer *> *output){
	boost::xint::integer q, i = 3;
	//CArray<void *, void *> output;
	boost::xint::integer *ptr;
	CString myStr = CString(boost::xint::to_wstring(x).c_str());
	int j;
	BOOL searchFlag,  flag = false;
	if (boost::xint::is_prime(x)){
		searchFlag = false;
		for (j = 0; j < output->GetSize(); j++){
			if (boost::xint::compare(*(output->GetAt(j)), boost::xint::integer(i)) == 0) { searchFlag = true; }
		}
		if (searchFlag == false) {
			ptr = new boost::xint::integer(x);
			output->Add(ptr);
		}
	}
	else if (x % 2 == 0) {
		IntegerFactorization(x / 2, output);
		searchFlag = false;
		for (j = 0; j < output->GetSize(); j++){
			if (boost::xint::compare(*(output->GetAt(j)), boost::xint::integer(2)) == 0) { searchFlag = true; }
		}
		if (searchFlag == false) { ptr = new boost::xint::integer(2); output->Add(ptr); }
	}
	else{
		q = boost::xint::square_root(x) + 1;
		while ((i < q) && (flag == false)){
			if (x % i == 0){
				if (boost::xint::is_prime(i) == true)
				{
					IntegerFactorization(x / i, output);					
					searchFlag = false;
					for (j = 0; j < output->GetSize(); j++){
						if (boost::xint::compare(*(output->GetAt(j)), boost::xint::integer(i)) == 0) { searchFlag = true; }
					}
					if (searchFlag == false) { ptr = new boost::xint::integer(i); output->Add(ptr); }
					flag = true;
				}
			}
			i = i + 2;
		}
		if (flag == false) { 
			searchFlag = false;
			for (j = 0; j < output->GetSize(); j++){
				if (boost::xint::compare(*(output->GetAt(j)), boost::xint::integer(i)) == 0) { searchFlag = true; }
			}
			if (searchFlag == false) {
				ptr = new boost::xint::integer(x);
				output->Add(ptr);
			}
		}
	}
}

void CDlgModArith::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TXT_MODULUS, mTxtModulus);
	DDX_Control(pDX, IDC_TXT_APOW, mTxtAPow);
	DDX_Control(pDX, IDC_TXT_BPOW, mTxtBPow);
	DDX_Control(pDX, IDC_TXT_ATOB, mTxtAtoBPow);
	DDX_Control(pDX, IDC_TXT_ATIMES, mTxtATimes);
	DDX_Control(pDX, IDC_TXT_BTIMES, mTxtBTimes);
	DDX_Control(pDX, IDC_TXT_ATIMESB, mTxtATimesB);
	DDX_Control(pDX, IDC_TXT_GENERATOR, mTxtGenerator);
	DDX_Control(pDX, IDC_TXTBITS, mTxtBits);
	DDX_Control(pDX, IDC_TXT_DISCLOG, mTxtDiscLog);
	DDX_Control(pDX, IDC_TXT_LOGSOL, mTxtLogSol);
	DDX_Control(pDX, IDC_TXT_TEXT, mTxtText);
	DDX_Control(pDX, IDC_TXT_NUM, mTxtNum);
	DDX_Control(pDX, IDC_TXT_APLUS, mTxtAPlus);
	DDX_Control(pDX, IDC_TXT_BPLUS, mTxtBPlus);
	DDX_Control(pDX, IDC_TXT_APLUSB, mTxtAPlusB);
	DDX_Control(pDX, IDC_TXT_ATOINVERT, mTxtAToInvert);
	DDX_Control(pDX, IDC_TXT_AINVERSE, mTxtAInverse);
}


BEGIN_MESSAGE_MAP(CDlgModArith, CDialogEx)
	ON_BN_CLICKED(IDC_BTN_ISPRIME, &CDlgModArith::OnBnClickedBtnIsprime)
	ON_EN_CHANGE(IDC_TXT_APOW, &CDlgModArith::OnEnChangeTxtApow)
	ON_EN_CHANGE(IDC_TXT_BPOW, &CDlgModArith::OnEnChangeTxtBpow)
	ON_EN_CHANGE(IDC_TXT_ATIMES, &CDlgModArith::OnEnChangeTxtAtimes)
	ON_EN_CHANGE(IDC_TXT_BTIMES, &CDlgModArith::OnEnChangeTxtBtimes)
	ON_BN_CLICKED(IDC_BTN_MAKEPRIME, &CDlgModArith::OnBnClickedBtnMakeprime)
	ON_BN_CLICKED(IDC_BTN_ISGENERATOR, &CDlgModArith::OnBnClickedBtnIsgenerator)
	ON_EN_CHANGE(IDC_TXT_MODULUS, &CDlgModArith::OnEnChangeTxtModulus)
	ON_BN_CLICKED(IDC_BTN_FINDEXP, &CDlgModArith::OnBnClickedBtnFindexp)
	ON_BN_CLICKED(IDC_BTN_T2N, &CDlgModArith::OnBnClickedBtnT2n)
	ON_BN_CLICKED(IDC_BTN_N2T, &CDlgModArith::OnBnClickedBtnN2t)
	ON_EN_CHANGE(IDC_TXT_APLUS, &CDlgModArith::OnEnChangeTxtAplus)
	ON_EN_CHANGE(IDC_TXT_BPLUS, &CDlgModArith::OnEnChangeTxtBplus)
	ON_EN_CHANGE(IDC_TXT_ATOINVERT, &CDlgModArith::OnEnChangeTxtAtoinvert)
END_MESSAGE_MAP()


// CDlgModArith message handlers


void CDlgModArith::OnBnClickedBtnIsprime()
{
	// TODO: Add your control notification handler code here
	boost::xint::integer i, val;
	CString myStr;
	this->mTxtModulus.GetWindowText(myStr);
	if (myStr.GetLength() > 0) { val = boost::xint::integer(myStr.GetBuffer()); }
	else { val = 0; }
	if (val > 1){
		BOOL flag = boost::xint::is_prime(val);
		if (flag == false){ AfxMessageBox(_T("This number is NOT prime.")); }
		else{ AfxMessageBox(_T("This number is prime.")); }
	}
	else { AfxMessageBox(_T("This is not a positive integer > 1.")); }
}


void CDlgModArith::OnEnChangeTxtApow()
{
	CString myStr, myStr1, myStr2;
	mTxtAPow.GetWindowText(myStr1);
	mTxtBPow.GetWindowText(myStr2);
	boost::xint::integer a, b, modulus, c;
	this->mTxtModulus.GetWindowText(myStr);

	if ((myStr.GetLength() > 0) && (myStr1.GetLength() > 0) && (myStr2.GetLength() > 0)){
		modulus = boost::xint::integer(myStr.GetBuffer());
		a = boost::xint::integer(myStr1.GetBuffer());
		b = boost::xint::integer(myStr2.GetBuffer());
		c = boost::xint::powmod(a, b, modulus);
		myStr = CString(boost::xint::to_wstring(c).c_str());
		mTxtAtoBPow.SetWindowTextW(myStr);
	}
	else{ mTxtAtoBPow.SetWindowTextW(CString("")); }
}


void CDlgModArith::OnEnChangeTxtBpow()
{
	CString myStr, myStr1, myStr2;
	mTxtAPow.GetWindowText(myStr1);
	mTxtBPow.GetWindowText(myStr2);
	boost::xint::integer a, b, modulus, c;
	this->mTxtModulus.GetWindowText(myStr);
	
	if ((myStr.GetLength() > 0) && (myStr1.GetLength() > 0) && (myStr2.GetLength() > 0)){
		modulus = boost::xint::integer(myStr.GetBuffer());
		a = boost::xint::integer(myStr1.GetBuffer());
		b = boost::xint::integer(myStr2.GetBuffer());
		c = boost::xint::powmod(a, b, modulus);
		myStr = CString(boost::xint::to_wstring(c).c_str());
		mTxtAtoBPow.SetWindowTextW(myStr);
	}
	else{ mTxtAtoBPow.SetWindowTextW(CString("")); }

}


void CDlgModArith::OnEnChangeTxtAtimes()
{
	CString myStr, myStr1, myStr2;
	mTxtATimes.GetWindowText(myStr1);
	mTxtBTimes.GetWindowText(myStr2);
	boost::xint::integer a, b, c, modulus;
	this->mTxtModulus.GetWindowText(myStr);
	
	if ((myStr.GetLength() > 0) && (myStr1.GetLength() > 0) && (myStr2.GetLength() > 0)){
		modulus = boost::xint::integer(myStr.GetBuffer());
		a = boost::xint::integer(myStr1.GetBuffer());
		b = boost::xint::integer(myStr2.GetBuffer());
		c = (a*b)%modulus;
		myStr = CString(boost::xint::to_wstring(c).c_str());
		mTxtATimesB.SetWindowTextW(myStr);
	}
	else{ mTxtATimesB.SetWindowTextW(CString("")); }
}


void CDlgModArith::OnEnChangeTxtBtimes()
{
	CString myStr, myStr1, myStr2;
	mTxtATimes.GetWindowText(myStr1);
	mTxtBTimes.GetWindowText(myStr2);
	boost::xint::integer a, b, modulus, c;
	this->mTxtModulus.GetWindowText(myStr);
	
	if ((myStr.GetLength() > 0) && (myStr1.GetLength() > 0) && (myStr2.GetLength() > 0)){
		modulus = boost::xint::integer(myStr.GetBuffer());
		a = boost::xint::integer(myStr1.GetBuffer());
		b = boost::xint::integer(myStr2.GetBuffer());
		c = (a*b) % modulus;
		myStr = CString(boost::xint::to_wstring(c).c_str());
		mTxtATimesB.SetWindowTextW(myStr);
	}
	else{ mTxtATimesB.SetWindowTextW(CString("")); }

}

BOOL CDlgModArith::OnInitDialog(){
	BOOL val = CDialogEx::OnInitDialog();
	this->mTxtBits.SetWindowTextW(_T("64"));
	return val;
}


void CDlgModArith::OnBnClickedBtnMakeprime()
{
	// TODO: Add your control notification handler code here
	CString myStr;
	int val;
	AfxGetApp()->BeginWaitCursor();
	boost::xint::integer p;
	boost::xint::default_random_generator gen;
	mTxtBits.GetWindowText(myStr);
	if (myStr.GetLength() > 0){
		val = _wtoi(myStr);
		p = boost::xint::integer::random_prime(gen, val);
		myStr = CString(boost::xint::to_wstring(p).c_str());
		mTxtModulus.SetWindowTextW(myStr);
	}
	else{
		AfxMessageBox(_T("You must specify the number of bits."));
	}
	AfxGetApp()->EndWaitCursor();
}


void CDlgModArith::OnBnClickedBtnIsgenerator()
{
	// TODO: Add your control notification handler code here
	int i = 0;
	boost::xint::integer val, p, x;
	BOOL flag = false;
	CString myStr;
	AfxGetApp()->BeginWaitCursor();
	mTxtModulus.GetWindowTextW(myStr);
	if (myStr.GetLength() == 0) { AfxMessageBox(_T("Error, you didn't select a number")); }
	else{
		p = boost::xint::integer(myStr.GetBuffer());
		if (!boost::xint::is_prime(p)){ AfxMessageBox(_T("Error, the modulus is not prime")); }
		else{
			mTxtGenerator.GetWindowTextW(myStr);
			if (myStr.GetLength() > 0){ x = boost::xint::integer(myStr.GetBuffer()); }
			else { AfxMessageBox(_T("No integer selected, using x = 2.")); x = 2; }
			if (factored == false) {
				IntegerFactorization(p - 1, &myArray); 
				factored = true;
			}
			
			//j = myArray.GetSize();
			for (i = 0; (i < myArray.GetSize()) && (flag == false); i++){
			//	myStr = CString(boost::xint::to_wstring(*((myArray.GetAt(i)))).c_str());
				val = boost::xint::powmod(x, (p - 1) / (*((myArray.GetAt(i)))), p);
				if (val == 1){ flag = true; }
				//x = *((myArray.GetAt(i)))
			}
			if (flag == true){ 
				AfxMessageBox(_T("This number is NOT a generator."));
			}
			else
			{
				AfxMessageBox(_T("This number is a generator."));
			}

		}
	}
	AfxGetApp()->EndWaitCursor();
}


void CDlgModArith::OnEnChangeTxtModulus()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialogEx::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
	int i;
	if (factored == true){
		for (i = 0; i < myArray.GetSize(); i++){
			delete (myArray.GetAt(i));
		}
		this->myArray.RemoveAll();
	}
	factored = false;

	CString myStr;
	double val;
	this->mTxtModulus.GetWindowTextW(myStr);
	int len = myStr.GetLength();
	if (len == 0){
		mTxtText.EnableWindow(false);
	}
	else{
		val = _wtof(myStr.GetBuffer());
		val = log(val) / log(26);
		i = val+1;
		if (i > 0){
			mTxtText.SetLimitText(i);
			mTxtText.EnableWindow(true);
			this->mTxtText.LimitText(i);
		}
		else{ mTxtText.EnableWindow(false); }
	}
		
}



void CDlgModArith::OnBnClickedBtnFindexp()
{
	AfxGetApp()->BeginWaitCursor();
	// TODO: Add your control notification handler code here
	CString myStr;
	boost::xint::integer i, val, b, p, x, sol;
	BOOL flag = false;
	mTxtModulus.GetWindowTextW(myStr);
	if (myStr.GetLength() == 0) { AfxMessageBox(_T("Error, you didn't select a modulus")); }
	else{
		p = boost::xint::integer(myStr.GetBuffer());
		//now get x
		mTxtGenerator.GetWindowTextW(myStr);
		if (myStr.GetLength() == 0){ AfxMessageBox(_T("No generator selected.")); }
		else { 
			x = boost::xint::integer(myStr.GetBuffer()); 
			//finally get the b
			mTxtDiscLog.GetWindowTextW(myStr);
			if (myStr.GetLength() == 0){ AfxMessageBox(_T("No value to solve for.")); }
			else{
				b = boost::xint::integer(myStr.GetBuffer());
				val = 1;
				for (i = 1; ((i < p - 1) && (flag == false)); i++){
					val = boost::xint::mulmod(val, x, p);
					if (boost::xint::compare(val, b) == 0) { sol = i; flag = true; }
				}
				if (flag == true){
					myStr = CString(boost::xint::to_wstring(sol).c_str());
					mTxtLogSol.SetWindowTextW(myStr);
				}
				else{
					AfxMessageBox(_T("Couldn't find a solution!  Are you sure the modulus is prime and x is a generator?"));
				}
			}
		}
	}
	AfxGetApp()->EndWaitCursor();
}





void CDlgModArith::OnBnClickedBtnT2n()
{
	// TODO: Add your control notification handler code here
	boost::xint::integer p, val = 0;
	int i, temp, len;
	CString myStr;

	mTxtText.GetWindowTextW(myStr);
	myStr = myStr.MakeUpper();
	myStr = this->KeepLettersOnly(myStr);
	len = myStr.GetLength();
	if (len == 0){ AfxMessageBox(_T("No text to convert.")); }
	else{
		for (i = 0; i < len; i++){
			temp = myStr.GetAt(i) - 'A';
			val = val + temp*boost::xint::pow(boost::xint::integer(26), boost::xint::integer(i));
		}
		mTxtModulus.GetWindowTextW(myStr);
		if (myStr.GetLength() != 0){
			p = boost::xint::integer(myStr.GetBuffer());
			if (p <= val) { AfxMessageBox(_T("Warning, the output number is larger than your modulus can encrypt.")); }
		}
		myStr = CString(boost::xint::to_wstring(val).c_str());
		mTxtNum.SetWindowTextW(myStr);
	}
}


void CDlgModArith::OnBnClickedBtnN2t()
{
	// TODO: Add your control notification handler code here
	boost::xint::integer p, j, val = 0;
	int i, k, maxCt;
	double tempVal;
	CString myStr;
	wchar_t *s1;
	mTxtNum.GetWindowTextW(myStr);
	if (myStr.GetLength() > 0){
		val = boost::xint::integer(myStr.GetBuffer());
		tempVal = _wtof(myStr.GetBuffer());
		mTxtModulus.GetWindowTextW(myStr);
		if (myStr.GetLength() != 0){
			p = boost::xint::integer(myStr.GetBuffer());
			if (p <= val){ 
				AfxMessageBox(_T("Warning, the input number is larger than your modulus can encrypt.")); 
				tempVal = log(tempVal) / log(26);
			}
			else{
				tempVal = (myStr.GetLength())/1.41497;

				//tempVal = log(boost::xint::to<double>(p)) / log(26);
			}
		}
		maxCt = tempVal + 1;
		s1 = new wchar_t[maxCt + 1];
		for (i = 0; i < maxCt; i++){
			k = boost::xint::to<int>(val % boost::xint::integer(26));
			s1[i] = 'A' + k;
			val = val / 26;
		}
		s1[i] = 0;
		myStr = CString(s1);
		mTxtText.SetWindowTextW(myStr);
		delete[]s1;
	}
	else{
		AfxMessageBox(_T("No number to convert."));
	}
	
}


CString CDlgModArith::KeepLettersOnly(CString tempStr){
	wchar_t *s1 = (wchar_t *)tempStr.GetBuffer();
	int len = tempStr.GetLength();
	int i, count = 0;
	wchar_t *s2 = new wchar_t[len + 1];
	CString outStr;

	for (i = 0; i < len; i++){
		if (((s1[i] <= 'Z') && (s1[i] >= 'A')) || ((s1[i] <= 'z') && (s1[i] >= 'a'))){
			s2[count] = s1[i];
			count++;
		}
	}
	s2[count] = 0;
	outStr = CString(s2);
	delete[]s2;
	return outStr;
}

void CDlgModArith::OnEnChangeTxtAplus()
{
	CString myStr, myStr1, myStr2;
	mTxtAPlus.GetWindowText(myStr1);
	mTxtBPlus.GetWindowText(myStr2);
	boost::xint::integer a, b, modulus, c;
	this->mTxtModulus.GetWindowText(myStr);
	

	if ((myStr1.GetLength() > 0) && (myStr2.GetLength() > 0) && (myStr.GetLength() > 0)){
		modulus = boost::xint::integer(myStr.GetBuffer());
		a = boost::xint::integer(myStr1.GetBuffer());
		b = boost::xint::integer(myStr2.GetBuffer());
		c = (a+b) % modulus;
		myStr = CString(boost::xint::to_wstring(c).c_str());
		mTxtAPlusB.SetWindowTextW(myStr);
	}
	else{ mTxtAPlusB.SetWindowTextW(CString("")); }

}


void CDlgModArith::OnEnChangeTxtBplus()
{
	CString myStr, myStr1, myStr2;
	mTxtAPlus.GetWindowText(myStr1);
	mTxtBPlus.GetWindowText(myStr2);
	boost::xint::integer a, b, modulus, c;
	this->mTxtModulus.GetWindowText(myStr);
	

	if ((myStr1.GetLength() > 0) && (myStr2.GetLength() > 0) && (myStr.GetLength() > 0)){
		modulus = boost::xint::integer(myStr.GetBuffer());
		a = boost::xint::integer(myStr1.GetBuffer());
		b = boost::xint::integer(myStr2.GetBuffer());
		c = (a + b) % modulus;
		myStr = CString(boost::xint::to_wstring(c).c_str());
		mTxtAPlusB.SetWindowTextW(myStr);
	}
	else{ mTxtAPlusB.SetWindowTextW(CString("")); }
}


void CDlgModArith::OnEnChangeTxtAtoinvert()
{
	CString myStr, myStr1;
	mTxtAToInvert.GetWindowText(myStr1);
	boost::xint::integer a, modulus, c;
	this->mTxtModulus.GetWindowText(myStr);
	
	if ((myStr1.GetLength() > 0) && (myStr.GetLength() > 0)){
		modulus = boost::xint::integer(myStr.GetBuffer());
		a = boost::xint::integer(myStr1.GetBuffer());
		c = boost::xint::invmod(a, modulus);
		myStr = CString(boost::xint::to_wstring(c).c_str());
		mTxtAInverse.SetWindowTextW(myStr);
	}
	else{ mTxtAInverse.SetWindowTextW(CString("")); }
}

void CDlgModArith::OnOK()
{

}