
// ScienceCamp-2014View.h : interface of the CScienceCamp2014View class
//

#pragma once

#include "resource.h"
#include "afxwin.h"
#include "DlgManual.h"

class CScienceCamp2014View : public CFormView
{
protected: // create from serialization only
	CScienceCamp2014View();
	DECLARE_DYNCREATE(CScienceCamp2014View)

public:
	enum{ IDD = IDD_SCIENCECAMP2014_FORM };

// Attributes
public:
	CScienceCamp2014Doc* GetDocument() const;

// Operations
public:

// Overrides
public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnInitialUpdate(); // called first time after construct

// Implementation
public:
	virtual ~CScienceCamp2014View();
	void CaesarEncrypt(void);
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedBtnEncrypt();
	afx_msg void OnBnClickedBtnDecrypt();
	afx_msg void OnBnClickedBtnAnalyze();
	void CaesarDecrypt();
	// No cipher selected
	CButton mBtnNone;
//	CButton mBtnAnalyzeNone;
	CButton mBtnEncrypt;
	CButton mBtnDecrypt;
	CButton mBtnAnalyze;
	CEdit mTxtPlain;
	CEdit mTxtCypher;
	CStatic mLblKey;
	CStatic mLblCypher;
	CEdit mTxtKey;
	CButton mChkPreserve;
	void ResizeControls();
	void SubstitutionEncrypt();
	void SubstitutionDecrypt();
	void VigenereEncrypt();
	void VigenereDecrypt();
	void ColumnarTransposeEncrypt();
	void ColumnarTransposeDecrypt();
	void AutokeyEncrypt();
	void AutokeyDecrypt();
	void FrequencyAnalysis();
	void Autocorrelation();
	void VigenereAnalysis();
	void DigraphAnalysis();
	CString KeepLettersOnly(CString tempStr);
	CEdit mTxtAnalysis;
	CString ShiftString(int shift, CString tempStr);
	int CorrelationCount(CString str1, CString str2); //counts the number of entries in the same location
	afx_msg void OnBnClickedRdoVigenere();
	int CaesarUnlocked;
	int SubstitutionUnlocked;
	int VigenereUnlocked;
	int ColumnarUnlocked;
	int AutokeyUnlocked;
	afx_msg void OnResetlocksResetalllocks();
	afx_msg void OnBnClickedBtnManual();
	CDlgManual *dlgPtr;
	afx_msg void OnFileModulararithmetic();
	afx_msg void OnBnClickedBtnAutokey();
};

#ifndef _DEBUG  // debug version in ScienceCamp-2014View.cpp
inline CScienceCamp2014Doc* CScienceCamp2014View::GetDocument() const
   { return reinterpret_cast<CScienceCamp2014Doc*>(m_pDocument); }
#endif

